package org.t2framework.mock;

import org.t2framework.action.impl.ActionContextImpl;
import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.WebContext;

import commons.meta.MethodDesc;
import commons.util.StringUtil;

public class MockActionContext extends ActionContextImpl {

	protected Request request;

	protected String pagePath;

	protected MethodDesc defaultMethodDesc;

	protected String pageTemplatePath;

	public MockActionContext() {
		super(null, null);
	}

	public MockActionContext(WebContext context) {
		super(context, null);
		this.request = context.getRequest();
	}

	public MockActionContext(WebContext context, PageDesc pageDesc) {
		super(context, pageDesc);
		this.request = context.getRequest();
	}

	public void setRequest(Request request) {
		this.request = request;
	}

	public Request getRequest() {
		return request;
	}

	public void setPagePath(String pagePath) {
		this.pagePath = pagePath;
	}

	public String getPagePath() {
		return pagePath;
	}

	@Override
	public MethodDesc getDefaultMethodDesc() {
		return defaultMethodDesc != null ? defaultMethodDesc : super
				.getDefaultMethodDesc();
	}

	public void setDefaultMethodDesc(MethodDesc defaultMethodDesc) {
		this.defaultMethodDesc = defaultMethodDesc;
	}

	public String getPageTemplatePath() {
		return !StringUtil.isEmpty(pageTemplatePath) ? pageTemplatePath : super
				.getPageTemplatePath();
	}

	public void setPageTemplatePath(String pageTemplatePath) {
		this.pageTemplatePath = pageTemplatePath;
	}

}
