package org.t2framework.handler.impl;

import javax.servlet.ServletException;

import org.t2framework.contexts.WebContext;
import org.t2framework.exception.ExceptionHandlerUnprocessingRuntimeException;
import org.t2framework.handler.GlobalExceptionHandler;
import org.t2framework.spi.Navigation;

import commons.util.Assertion;
import commons.util.Logger;

/**
 * Concrete class of GlobalExceptionHandler.
 * 
 * @author shot
 * @see org.t2framework.handler.GlobalExceptionHandler
 */
public class GlobalExceptionHandlerImpl implements GlobalExceptionHandler {

	private static Logger logger = Logger
			.getLogger(GlobalExceptionHandlerImpl.class);

	@Override
	public boolean isTargetException(Throwable t) {
		Assertion.notNull(t);
		return true;
	}

	/**
	 * Just logging and wraps to ServletException by default.
	 */
	@Override
	public Navigation handleException(final Throwable t,
			final WebContext context) throws ServletException {
		Throwable target = t;
		if (t instanceof ExceptionHandlerUnprocessingRuntimeException) {
			target = t.getCause();
		}
		logger.error(t.getMessage());
		throw new ServletException(target);
	}

}
