package org.t2framework.handler.impl;

import java.util.List;

import org.t2framework.contexts.WebContext;
import org.t2framework.exception.ExceptionHandlerCyclicRuntimeException;
import org.t2framework.exception.ExceptionHandlerUnprocessingRuntimeException;
import org.t2framework.handler.ExceptionHandler;
import org.t2framework.handler.ExceptionHandlerChain;
import org.t2framework.spi.Navigation;

import commons.util.Assertion;

public class ExceptionHandlerChainImpl implements ExceptionHandlerChain {

	protected final List<ExceptionHandler<Throwable, Exception>> exceptionHandlers;

	public ExceptionHandlerChainImpl(
			List<ExceptionHandler<Throwable, Exception>> exceptionHandlers) {
		this.exceptionHandlers = Assertion.notNull(exceptionHandlers);
	}

	@Override
	public Navigation doChain(final Throwable t, final WebContext context) {
		Throwable target = t;
		Navigation n = null;
		Exception cyclic = null;
		for (ExceptionHandler<Throwable, Exception> handler : exceptionHandlers) {
			if (!handler.isTargetException(target)) {
				continue;
			}
			try {
				n = handler.handleException(t, context);
			} catch (Exception e) {
				if (e.equals(cyclic)) {
					throw new ExceptionHandlerCyclicRuntimeException(target);
				}
				target = e;
				cyclic = e;
				n = null;
				continue;
			}
			if (n != null) {
				break;
			}
		}
		if (n == null && target != t) {
			throw new ExceptionHandlerUnprocessingRuntimeException(target);
		}
		return n;
	}

}
