package org.t2framework.handler;

import java.util.List;

/**
 * 
 * @author shot
 */
public interface ExceptionHandlerFactory {

	/**
	 * Create and return list of {@code ExceptionHandler}.This method must not
	 * return null.
	 * 
	 * @return List<ExceptionHandler>
	 */
	List<ExceptionHandler<Throwable, Exception>> createExceptionHandlers();

	/**
	 * Create and return {@code GlobalExceptionHandler}.This method must not
	 * return null.
	 * 
	 * @return GlobalExceptionHandler
	 */
	GlobalExceptionHandler createGlobalExceptionHandler();
}
