package org.t2framework.handler;

import org.t2framework.contexts.WebContext;
import org.t2framework.spi.Navigation;

/**
 * 
 * ExceptionHandler is an interface that handles an Exception.
 * 
 * @author shot
 * 
 * @param <T>
 *            as parameter exception.
 * @param <R>
 *            as return exception if needed.
 */
public interface ExceptionHandler<T extends Throwable, R extends Exception> {

	boolean isTargetException(Throwable t);

	Navigation handleException(T t, WebContext context) throws R;

}
