package org.t2framework.filter;

import javax.servlet.FilterConfig;

import org.t2framework.T2ConfigurationKey;
import org.t2framework.exception.NoRootPackageDefinedException;

import commons.Constants;
import commons.util.StringUtil;

/**
 * T2 inner configuration utility.
 * 
 * @author shot
 */
class T2ConfigurationUtil {

	public static final boolean EAGER_LOAD_DEFAULT_VALUE = false;

	public static String getAdapterClass(final FilterConfig config) {
		String adapterClass = config
				.getInitParameter(T2ConfigurationKey.CONTAINER_ADAPTER_CLASS);
		if (StringUtil.isEmpty(adapterClass)) {
			adapterClass = T2ConfigurationKey.DEFAULT_ADAPTER_CLASS;
		}
		return adapterClass;
	}

	public static String getEncoding(final FilterConfig config) {
		String encoding = config.getServletContext().getInitParameter(
				T2ConfigurationKey.ENCODING_KEY);
		if (encoding == null) {
			encoding = T2Filter.DEFAULT_ENCODING;
		}
		return encoding;
	}

	public static String getUserConfig(FilterConfig config) {
		return config.getInitParameter(T2ConfigurationKey.USER_CONFIG_KEY);
	}

	public static String[] getRootPackage(final FilterConfig config) {
		String roots = config
				.getInitParameter(T2ConfigurationKey.ROOT_PACKAGE_KEY);
		if (StringUtil.isEmpty(roots)) {
			throw new NoRootPackageDefinedException();
		}
		return split(roots);
	}

	public static String[] getExcludeResources(final FilterConfig config) {
		String s = config
				.getInitParameter(T2ConfigurationKey.EXCLUDE_RESOURCES_KEY);
		if (StringUtil.isEmpty(s)) {
			return Constants.EMPTY_STRING_ARRAY;
		}
		return split(s);
	}

	public static boolean getEagerLoad(final FilterConfig config) {
		String eagerLoad = config
				.getInitParameter(T2ConfigurationKey.EAGER_LODE_KEY);
		if (StringUtil.isEmpty(eagerLoad)) {
			return EAGER_LOAD_DEFAULT_VALUE;
		}
		return Boolean.valueOf(eagerLoad);
	}

	protected static String[] split(String s) {
		return StringUtil.split(s, ", ");
	}

}
