package org.t2framework.filter;

import static org.t2framework.filter.T2ConfigurationUtil.getAdapterClass;
import static org.t2framework.filter.T2ConfigurationUtil.getEagerLoad;
import static org.t2framework.filter.T2ConfigurationUtil.getEncoding;
import static org.t2framework.filter.T2ConfigurationUtil.getExcludeResources;
import static org.t2framework.filter.T2ConfigurationUtil.getRootPackage;
import static org.t2framework.filter.T2ConfigurationUtil.getUserConfig;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

import org.t2framework.adapter.ContainerAdapter;
import org.t2framework.contexts.WebApplication;
import org.t2framework.contexts.impl.WebApplicationImpl;
import org.t2framework.exception.T2BaseRuntimeException;
import org.t2framework.handler.GlobalExceptionHandler;
import org.t2framework.spi.AnnotationResolverCreator;

import commons.bootstrap.CommonsInitializer;
import commons.util.Reflections.ClassUtil;

/**
 * The dirty class for initializing some.
 * 
 * @author shot
 */
class Initializer {

	public InitContext execute(FilterConfig config) throws ServletException {
		InitContext context = new InitContext();
		AnnotationResolverCreator resolverCreator = CommonsInitializer
				.get(AnnotationResolverCreator.class);
		if (resolverCreator == null) {
			throw new T2BaseRuntimeException();
		}
		context.resolverCreator = resolverCreator;
		context.encoding = getEncoding(config);
		context.rootPackages = getRootPackage(config);
		context.userConfigPath = getUserConfig(config);
		context.excludes = getExcludeResources(config);
		context.adapter = getContainerAdapterClass(config,
				context.userConfigPath);
		boolean eagerload = getEagerLoad(config);
		final WebApplication webapp = new WebApplicationImpl(context.adapter,
				config, context.encoding, context.rootPackages, eagerload,
				resolverCreator);
		context.webapplication = webapp;
		context.globalExceptionHandler = context.adapter
				.createGlobalExceptionHandler();
		return context;
	}

	protected ContainerAdapter<?> getContainerAdapterClass(
			final FilterConfig config, String userConfigPath)
			throws ServletException {
		ContainerAdapter<?> adapter = null;
		try {
			String adapterClass = getAdapterClass(config);
			Class<ContainerAdapter<?>> c = ClassUtil.forName(adapterClass);
			adapter = ClassUtil.newInstance(c);
			adapter.setFilterConfig(config);
			adapter.setServletContext(config.getServletContext());
			adapter.init(userConfigPath);
		} catch (Throwable t) {
			throw new ServletException(t);
		}
		return adapter;
	}

	public static class InitContext {

		GlobalExceptionHandler globalExceptionHandler;

		WebApplication webapplication;

		String[] excludes;

		ContainerAdapter<?> adapter;

		AnnotationResolverCreator resolverCreator;

		String encoding;

		String[] rootPackages;

		String userConfigPath;

	}
}
