/**
 * 
 */
package org.t2framework.contexts.impl;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.contexts.Response;

import commons.exception.IORuntimeException;
import commons.util.Assertion;
import commons.util.ContentTypeUtil;
import commons.util.ServletUtil;

/**
 * Concrete class of org.t2framework.contexts.Response.
 * 
 * @author shot
 * @see org.t2framework.contexts.Response
 */
public class ResponseImpl implements Response {

	protected final HttpServletResponse response;

	protected String contentType;

	public ResponseImpl(HttpServletResponse response) {
		this.response = Assertion.notNull(response);
		this.contentType = response.getContentType();
	}

	@Override
	public String getCharacterEncoding() {
		final String type = getContentType();
		String encoding = ContentTypeUtil.getEncodingFromContentType(type);
		if (encoding != null) {
			return encoding;
		}
		return response.getCharacterEncoding();
	}

	@Override
	public String getContentType() {
		return contentType;
	}

	@Override
	public ServletOutputStream getOutputStream() throws IORuntimeException {
		try {
			return response.getOutputStream();
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
	}

	@Override
	public void setContentType(String contentType) {
		this.contentType = Assertion.notNull(contentType);
		response.setContentType(contentType);
	}

	@Override
	public HttpServletResponse getNativeResource() {
		return response;
	}

	@Override
	public void redirect(String path) {
		Assertion.notNull(path);
		ServletUtil.redirect(response, path);
	}

	@Override
	public void setHeader(String key, String value) {
		Assertion.notNull(key);
		Assertion.notNull(value);
		getNativeResource().setHeader(key, value);
	}

	@Override
	public void setNoCache() {
		response.setHeader("Pragma", "No-cache");
		response
				.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
		response.setDateHeader("Expires", 1);
	}

	@Override
	public void writeAndFlush(String s) throws IOException {
		PrintWriter writer = getWriter();
		writer.write(s);
		writer.flush();
	}

	@Override
	public void write(String s) throws IOException {
		PrintWriter writer = getWriter();
		writer.write(s);
	}

	protected PrintWriter getWriter() throws IOException {
		return getNativeResource().getWriter();
	}

	@Override
	public void flush() throws IOException {
		PrintWriter writer = getWriter();
		writer.flush();
	}

}
