/**
 * 
 */
package org.t2framework.contexts.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.contexts.HttpMethod;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.Session;

import commons.exception.IORuntimeException;
import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.ServletUtil;
import commons.util.StringUtil;

/**
 * @author shot
 */
public class RequestImpl implements Request {

	protected HttpServletRequest request;

	protected HttpServletResponse response;

	protected Session session;

	protected boolean amfEnabled;

	public RequestImpl(final HttpServletRequest request,
			final HttpServletResponse response) {
		this(request, response, false);
	}

	public RequestImpl(final HttpServletRequest request,
			final HttpServletResponse response, final boolean amfEnabled) {
		this.request = Assertion.notNull(request);
		this.response = Assertion.notNull(response);
		this.amfEnabled = amfEnabled;
		init();
	}

	protected void init() {
	}

	public String getContextPath() {
		return getNativeResource().getContextPath();
	}

	public String getEncoding() {
		return getNativeResource().getCharacterEncoding();
	}

	public Locale getLocale() {
		return getNativeResource().getLocale();
	}

	public HttpMethod getMethod() {
		final String method = getNativeResource().getMethod();
		return HttpMethod.getMethodType(method);
	}

	public String getPath() {
		return getNativeResource().getPathInfo();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getAttributeNames() {
		List<String> ret = CollectionsUtil.newArrayList();
		for (Enumeration<String> e = getNativeResource().getAttributeNames(); e
				.hasMoreElements();) {
			ret.add(e.nextElement());
		}
		return ret;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, Object> getAttributesAsMap() {
		Map<String, Object> ret = CollectionsUtil.newHashMap();
		for (Enumeration<String> e = getNativeResource().getAttributeNames(); e
				.hasMoreElements();) {
			String key = (String) e.nextElement();
			Object value = getNativeResource().getAttribute(key);
			ret.put(key, value);
		}

		return ret;
	}

	@SuppressWarnings("unchecked")
	public <V> V getAttribute(String key) {
		return (V) getNativeResource().getAttribute(key);
	}

	@SuppressWarnings("unchecked")
	public synchronized <V> V removeAttribute(String key) {
		Object ret = getAttribute(key);
		getNativeResource().removeAttribute(key);
		return (V) ret;
	}

	public synchronized <V> void setAttribute(String key, V value) {
		Assertion.notNull(key);
		getNativeResource().setAttribute(key, value);
	}

	@SuppressWarnings("unchecked")
	public List<String> getParameterNames() {
		List<String> list = CollectionsUtil.newArrayList();
		Map<String, Object> parameterMap = getNativeResource()
				.getParameterMap();
		for (String s : parameterMap.keySet()) {
			list.add(s);
		}
		return list;
	}

	@SuppressWarnings("unchecked")
	public Map<String, String[]> getParametersAsMap() {
		return request.getParameterMap();
	}

	public String[] getParameters(String key) {
		return getNativeResource().getParameterValues(key);
	}

	@Override
	public HttpServletRequest getNativeResource() {
		return request;
	}

	@Override
	public Session getSession() {
		return session;
	}

	@Override
	public void setSession(Session session) {
		this.session = Assertion.notNull(session);
	}

	@Override
	public void forward(String path) {
		RequestDispatcher dispatcher = getNativeResource()
				.getRequestDispatcher(path);
		ServletUtil.forward(dispatcher, request, response);
	}

	@Override
	public boolean isForwarded() {
		return request.getAttribute(JAVAX_FORWARD_REQUEST_URI) != null;
	}

	@Override
	public String getParameter(String key) {
		return getNativeResource().getParameter(key);
	}

	@Override
	public boolean hasMultipleParameters(String key) {
		String[] values = getNativeResource().getParameterValues(key);
		return values != null && values.length > 1;
	}

	@Override
	public int getContentLength() {
		return getNativeResource().getContentLength();
	}

	@Override
	public InputStream getInputStream() throws IORuntimeException {
		try {
			return getNativeResource().getInputStream();
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
	}

	@Override
	public boolean isMultipartType() {
		return ServletUtil.isMultipart(getNativeResource());
	}

	@Override
	public boolean isAjaxRequest() {
		HttpServletRequest req = getNativeResource();
		String value = req.getHeader(AJAX_REQUEST_MARKER_KEY);
		if (StringUtil.isEmpty(value)) {
			return false;
		}
		return AJAX_REQUEST_MARKER_VALUE.equalsIgnoreCase(value);
	}

	/**
	 * This method will work from version 0.5, called "Star".
	 */
	@Override
	public boolean isAmfRequest() {
		return false;
	}

}
