/**
 * 
 */
package org.t2framework.contexts.impl;

import org.t2framework.contexts.Application;
import org.t2framework.contexts.Chain;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.Response;
import org.t2framework.contexts.Session;
import org.t2framework.contexts.WebContext;

import commons.util.Assertion;

/**
 * Default context class for T2.
 * 
 * @author shot
 */
public class ContextImpl extends WebContext {

	protected Request request;

	protected Response response;

	protected Application application;

	protected Session session;

	protected Chain chain;

	public ContextImpl(final Request request, final Response response,
			final Application application, final Session session, Chain chain) {
		this.request = Assertion.notNull(request);
		this.response = Assertion.notNull(response);
		this.application = Assertion.notNull(application);
		this.session = Assertion.notNull(session);
		this.chain = chain;
	}

	@Override
	public Request getRequest() {
		return request;
	}

	@Override
	public Response getResponse() {
		return response;
	}

	@Override
	public Application getApplication() {
		return application;
	}

	@Override
	public Session getSession() {
		return session;
	}

	@Override
	public Chain getChain() {
		return chain;
	}

}
