package org.t2framework.contexts.impl;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;

import org.t2framework.contexts.Chain;
import org.t2framework.contexts.WebContext;

import commons.util.Assertion;

/**
 * Concrete class of Chain.
 * 
 * @author shot
 * 
 */
public class ChainImpl implements Chain {

	protected final FilterChain chain;

	public ChainImpl(final FilterChain chain) {
		this.chain = Assertion.notNull(chain);
	}

	@Override
	public void doFilter(WebContext context) throws IOException,
			ServletException {
		chain.doFilter(context.getRequest().getNativeResource(), context
				.getResponse().getNativeResource());
	}

}
