/**
 * 
 */
package org.t2framework.contexts.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

import org.t2framework.T2ConfigurationKey;
import org.t2framework.contexts.Application;

import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * An Application implementation for ServletContext.
 * 
 * @author shot
 */
public class ApplicationImpl implements Application {

	protected ServletContext servletContext;

	protected Map<String, String> filterInitParamMap;

	public ApplicationImpl(final ServletContext servletContext,
			final FilterConfig config) {
		Assertion.notNulls(servletContext, config);
		this.servletContext = servletContext;
		initFilterInitParamMap(config);
	}

	@SuppressWarnings("unchecked")
	protected void initFilterInitParamMap(FilterConfig config) {
		Map<String, String> map = CollectionsUtil.newHashMap();
		for (Enumeration<String> e = config.getInitParameterNames(); e
				.hasMoreElements();) {
			String name = e.nextElement();
			String value = config.getInitParameter(name);
			map.put(name, value);
		}
		this.filterInitParamMap = map;
	}

	@Override
	public String getInitParameter(String key) {
		return servletContext.getInitParameter(key);
	}

	@Override
	public URL getResource(String path) throws MalformedURLException {
		return servletContext.getResource(path);
	}

	@Override
	public InputStream getResourceAsStream(String path) {
		return servletContext.getResourceAsStream(path);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Set<String> getResourcePaths(String path) {
		return servletContext.getResourcePaths(path);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getAttributeNames() {
		List<String> ret = CollectionsUtil.newArrayList();
		for (Enumeration<String> e = getNativeResource().getAttributeNames(); e
				.hasMoreElements();) {
			ret.add(e.nextElement());
		}
		return ret;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, Object> getAttributesAsMap() {
		Map<String, Object> ret = CollectionsUtil.newHashMap();
		for (Enumeration<String> e = getNativeResource().getAttributeNames(); e
				.hasMoreElements();) {
			String key = (String) e.nextElement();
			Object value = servletContext.getAttribute(key);
			ret.put(key, value);
		}

		return ret;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <V> V getAttribute(String key) {
		return (V) getNativeResource().getAttribute(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	public synchronized <V> V removeAttribute(String key) {
		Object ret = getAttribute(key);
		getNativeResource().removeAttribute(key);
		return (V) ret;
	}

	@Override
	public synchronized <V> void setAttribute(String key, V value) {
		getNativeResource().setAttribute(key, value);
	}

	@Override
	public ServletContext getNativeResource() {
		return servletContext;
	}

	@Override
	public Map<String, String> getFilterInitParamMap() {
		return filterInitParamMap;
	}

	@Override
	public String getFilterInitParamValue(String name) {
		return filterInitParamMap.get(Assertion.notNull(name));
	}

	@Override
	public String getRootPackage() {
		return filterInitParamMap.get(T2ConfigurationKey.ROOT_PACKAGE_KEY);
	}

}
