package org.t2framework.contexts.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

import org.t2framework.annotation.core.Default;
import org.t2framework.contexts.ActionMethodDesc;

import commons.meta.BeanDesc;
import commons.meta.MethodDesc;
import commons.meta.PropertyDesc;
import commons.util.Assertion;

public class ActionMethodUtil {

	public static ActionMethodDesc createActionMethodDesc(BeanDesc<?> pbd,
			Set<Class<? extends Annotation>> actionAnnotationSet) {
		Assertion.notNull(pbd);
		Assertion.notNull(actionAnnotationSet);
		ActionMethodDesc amd = new ActionMethodDescImpl();
		List<MethodDesc> methodDescList = pbd.getAllMethodDesc();
		for (MethodDesc md : methodDescList) {
			setupActionMethodDesc(md, amd, actionAnnotationSet);
		}
		for (PropertyDesc<?> pd : pbd.getAllPropertyDesc()) {
			if (pd.isWritable()) {
				setupActionMethodDesc(pd.getWriteMethodDesc(), amd,
						actionAnnotationSet);
			}
			if (pd.isReadable()) {
				setupActionMethodDesc(pd.getReadMethodDesc(), amd,
						actionAnnotationSet);
			}
		}
		return amd;
	}

	protected static void setupActionMethodDesc(MethodDesc md,
			ActionMethodDesc amd,
			Set<Class<? extends Annotation>> actionAnnotationSet) {
		for (Class<? extends Annotation> annotationClass : actionAnnotationSet) {
			if (md.hasConfigDesc(annotationClass)) {
				amd.addTargetMethodDesc(md);
				return;
			}
		}
	}

	public static MethodDesc resolveDefaultMethodDesc(BeanDesc<?> beanDesc) {
		for (MethodDesc md : beanDesc.getAllMethodDesc()) {
			if (md.hasConfigDesc(Default.class)) {
				return md;
			}
		}
		for (PropertyDesc<?> pd : beanDesc.getAllPropertyDesc()) {
			if (pd.hasConfigDesc(Default.class)) {
				return (pd.isReadable()) ? pd.getReadMethodDesc() : pd
						.getWriteMethodDesc();
			}
		}
		return null;
	}
}
