package org.t2framework.contexts.impl;

import java.util.Map;
import java.util.Set;

import org.t2framework.contexts.ActionMethodDesc;

import commons.meta.MethodDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * TODO need to move somewhere?
 * 
 * @author shot
 */
public class ActionMethodDescImpl implements ActionMethodDesc {

	protected Map<String, MethodDesc> methodDescMap = CollectionsUtil
			.newHashMap();

	@Override
	public void addTargetMethodDesc(MethodDesc methodDesc) {
		Assertion.notNull(methodDesc);
		final String methodName = methodDesc.getMethodName();
		addTargetMethodDesc(methodName, methodDesc);
	}

	@Override
	public void addTargetMethodDesc(String alias, MethodDesc methodDesc) {
		Assertion.notNull(alias);
		Assertion.notNull(methodDesc);
		methodDescMap.put(alias, methodDesc);
	}

	@Override
	public MethodDesc getMethodDesc(String methodName) {
		Assertion.notNull(methodName);
		return methodDescMap.get(methodName);
	}

	@Override
	public boolean isEmpty() {
		return methodDescMap.isEmpty();
	}

	@Override
	public int getMethodDescSize() {
		return methodDescMap.size();
	}

	@Override
	public Set<String> getMethodNameList() {
		return methodDescMap.keySet();
	}

	@Override
	public void addDefaultMethodDesc(MethodDesc methodDesc) {
		Assertion.notNull(methodDesc);
		addTargetMethodDesc(methodDesc);
	}

}
