package org.t2framework.contexts;

import java.util.Map;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * WebApplication is a factory interface to create context object. This class
 * has responsibility to create meta object at the initialized time for POJO
 * instance called Page, which is an object to communicate with T2, and keeps as
 * map<String, PageDesc> for the time of invoking appropriate method of a
 * page.The scope of WebApplication is same as T2Filter.
 * 
 * @author shot
 */
public interface WebApplication {

	WebContext createContext(HttpServletRequest req, HttpServletResponse res,
			FilterChain chain);

	Map<String, PageDesc> getPageDescMap();

	String getEncoding();

	String[] getRootPackages();
}
