package org.t2framework.contexts;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServletResponse;

import commons.exception.IORuntimeException;

/**
 * Response is represented class as user response and hides and wraps
 * HttpServletResponse.
 * 
 * @author shot
 * @see javax.servlet.http.HttpServletResponse
 */
public interface Response extends NativeResource<HttpServletResponse> {

	OutputStream getOutputStream() throws IORuntimeException;

	void setContentType(String contentType);

	void setHeader(String key, String value);

	String getContentType();

	String getCharacterEncoding();

	void redirect(String path);

	void setNoCache();

	void write(String s) throws IOException;

	void writeAndFlush(String s) throws IOException;

	void flush() throws IOException;
}
