package org.t2framework.contexts;

import java.io.InputStream;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import commons.exception.IORuntimeException;

/**
 * Request is represented class as user request and hides and wraps
 * HttpServletRequest.
 * 
 * @author shot
 * @see javax.servlet.http.HttpServletRequest
 */
public interface Request extends AttributesAssembler, ParameterAssembler,
		NativeResource<HttpServletRequest> {

	String JAVAX_FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";

	String AJAX_REQUEST_MARKER_KEY = "X-Requested-With";

	String AJAX_REQUEST_MARKER_VALUE = "XMLHttpRequest";

	String getPath();

	String getContextPath();

	HttpMethod getMethod();

	String getEncoding();

	Locale getLocale();

	void setSession(Session session);

	Session getSession();

	void forward(String path);

	boolean isForwarded();

	boolean isAmfRequest();

	boolean isAjaxRequest();

	int getContentLength();

	InputStream getInputStream() throws IORuntimeException;

	boolean isMultipartType();

}
