package org.t2framework.contexts;

import org.t2framework.util.UrlTemplate;

import commons.meta.ClassDesc;
import commons.meta.MethodDesc;

/**
 * PageDesc is a meta class of T2 Page and keeps name, action methods, which is
 * called from view, and url templates.
 * 
 * @author shot
 */
public interface PageDesc {

	String getPackageName();

	String getPageName();

	ClassDesc<?> getPageClassDesc();

	MethodDesc getDefaultMethodDesc();

	boolean hasDefaultMethodDesc();

	ActionMethodDesc getActionMethodDesc();

	boolean match(String url);

	UrlTemplate getUrlTemplate();

	String getPageTemplatePath();

}
