package org.t2framework.contexts;

import java.lang.annotation.Annotation;

/**
 * HttpMethod is enum of http method.
 * 
 * @author shot
 */
public enum HttpMethod {

	GET {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.GET.class;
		}

	},
	POST {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.POST.class;
		}

	},
	PUT {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.PUT.class;
		}

	},
	DELETE {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.DELETE.class;
		}

	},
	HEAD {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.HEAD.class;
		}

	},
	OPTIONS {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.OPTIONS.class;
		}

	},
	TRACE {
		public Class<? extends Annotation> getAnnotation() {
			return org.t2framework.annotation.composite.TRACE.class;
		}

	};

	public static HttpMethod getMethodType(String method) {
		if (method == null) {
			return null;
		}
		final String s = method.toUpperCase();
		if ("GET".equals(s)) {
			return GET;
		} else if ("POST".equals(s)) {
			return POST;
		} else if ("PUT".equals(s)) {
			return PUT;
		} else if ("DELETE".equals(s)) {
			return DELETE;
		} else if ("HEAD".equals(s)) {
			return HEAD;
		} else if ("OPTIONS".equals(s)) {
			return OPTIONS;
		} else if ("TRACE".equals(s)) {
			return TRACE;
		} else {
			throw new IllegalStateException("No such http method.");
		}
	}

	public String toString() {
		return this.toString().toLowerCase();
	}

	public abstract Class<? extends Annotation> getAnnotation();
}
