package org.t2framework.contexts;

import java.util.Locale;

import commons.annotation.Published;

/**
 * The root context class that has all information you need.
 * 
 * @author shot
 */
@Published
public interface Context<REQ, RES, APP, SES> {

	REQ getRequest();

	RES getResponse();

	APP getApplication();

	SES getSession();

	/**
	 * Return requested locale.
	 * 
	 * @return
	 */
	Locale getRequestLocale();

	/**
	 * Return the locale where T2 is running.
	 * 
	 * @return
	 */
	Locale getDefaultLocale();

	Chain getChain();
}
