package org.t2framework.contexts;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;

/**
 * Application is a container for initialized parameter, or long-span
 * attributes. Application holds ServletContext internally.
 * 
 * @author shot
 */
public interface Application extends AttributesAssembler,
		NativeResource<ServletContext> {

	String getInitParameter(String key);

	URL getResource(String path) throws MalformedURLException;

	InputStream getResourceAsStream(String path);

	Set<String> getResourcePaths(String path);

	Map<String, String> getFilterInitParamMap();

	String getFilterInitParamValue(String key);

	String getRootPackage();

}
