package org.t2framework.configuration;

import org.t2framework.behavior.ApplicationBehavior;
import org.t2framework.behavior.RequestBehavior;
import org.t2framework.behavior.SessionBehavior;

import lucy.ConfigBindResult;
import lucy.ConfigDescBinder;
import lucy.DefaultLucyConfiguration;
import lucy.ConfigDescBinderFactory.DefaultConfigDescBinderImpl;
import lucy.spi.Behavior;

import commons.meta.BeanDesc;
import commons.meta.InstanceConfigDescFactory;

/**
 * T2LucyConfiguration extends DefaultLucyConfiguration to use servlet
 * environment scope. These are used by Lucy scope/behavior mechanism.
 * 
 * @author shot
 */
public class T2LucyConfiguration extends DefaultLucyConfiguration {

	@Override
	public ConfigDescBinder loadConfigDescBinder() {
		return new DefaultConfigDescBinderImpl() {

			@Override
			protected void init() {
				super.init();
				addDefaultBehavior(RequestBehavior.class);
				addDefaultBehavior(SessionBehavior.class);
				addDefaultBehavior(ApplicationBehavior.class);
				InstanceConfigDescFactory
						.addInstanceConfigDesc(new RequestInstanceConfigDesc());
				InstanceConfigDescFactory
						.addInstanceConfigDesc(new SessionInstanceConfigDesc());
				InstanceConfigDescFactory
						.addInstanceConfigDesc(new ApplicationInstanceConfigDesc());
			}

			@Override
			public void addBehavior(Class<? extends Behavior> behavior) {
				super.addBehavior(behavior);
			}

			@Override
			public <T> ConfigBindResult bind(BeanDesc<T> beanDesc) {
				return super.bind(beanDesc);
			}

		};
	}

}
