package org.t2framework.behavior;

import org.t2framework.configuration.SessionInstanceConfigDesc;
import org.t2framework.contexts.AttributeContainer;
import org.t2framework.contexts.WebContext;

import commons.annotation.ConfigurationTarget;
import commons.annotation.core.Session;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;

/**
 * SessionBehavior is a behavior class to get component from session.This class
 * is used with Lucy, a simple DI container.
 * 
 * @author shot
 */
@ConfigurationTarget( { Session.class, SessionInstanceConfigDesc.class })
public class SessionBehavior extends AbstractAttributeBehavior {

	public SessionBehavior(BeanDesc<? extends Object> beanDesc,
			ClassDesc<? extends Object> cd, ConfigDesc configDesc) {
		super(beanDesc, cd, configDesc);
	}

	@Override
	protected AttributeContainer getAttributeContainer() {
		return WebContext.get().getSession();
	}

}
