package org.t2framework.behavior;

import org.t2framework.configuration.RequestInstanceConfigDesc;
import org.t2framework.contexts.AttributeContainer;
import org.t2framework.contexts.WebContext;

import commons.annotation.ConfigurationTarget;
import commons.annotation.core.Request;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;

/**
 * RequestBehavior is a behavior class to get component from request.This class
 * is used with Lucy, a simple DI container.
 * 
 * @author shot
 */
@ConfigurationTarget( { Request.class, RequestInstanceConfigDesc.class })
public class RequestBehavior extends AbstractAttributeBehavior {

	public RequestBehavior(BeanDesc<? extends Object> beanDesc,
			ClassDesc<? extends Object> cd, ConfigDesc configDesc) {
		super(beanDesc, cd, configDesc);
	}

	@Override
	protected AttributeContainer getAttributeContainer() {
		return WebContext.get().getRequest();
	}

}
