package org.t2framework.behavior;

import org.t2framework.configuration.ApplicationInstanceConfigDesc;
import org.t2framework.contexts.AttributeContainer;
import org.t2framework.contexts.WebContext;

import commons.annotation.ConfigurationTarget;
import commons.annotation.core.Application;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;

/**
 * ApplicationBehavior is a behavior class to get component from
 * application.This class is used with Lucy, a simple DI container.
 * 
 * @author taichi
 */
@ConfigurationTarget( { Application.class, ApplicationInstanceConfigDesc.class })
public class ApplicationBehavior extends AbstractAttributeBehavior {

	public ApplicationBehavior(BeanDesc<? extends Object> beanDesc,
			ClassDesc<? extends Object> cd, ConfigDesc configDesc) {
		super(beanDesc, cd, configDesc);
	}

	@Override
	protected AttributeContainer getAttributeContainer() {
		return WebContext.get().getApplication();
	}

}
