package org.t2framework.behavior;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.t2framework.contexts.AttributeContainer;

import lucy.Lifecycle;
import lucy.Lucy;
import lucy.spi.AbstractBehavior;

import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.util.Reflections.ClassUtil;

/**
 * AbstractAttributeBehavior is an abstract class for getting a component from
 * AttributeContainer.
 * 
 * @author shot
 * @see org.t2framework.behavior.RequestBehavior
 * @see org.t2framework.behavior.SessionBehavior
 */
public abstract class AbstractAttributeBehavior extends AbstractBehavior {

	protected Lock lock = new ReentrantLock();

	public AbstractAttributeBehavior(BeanDesc<? extends Object> beanDesc,
			ClassDesc<? extends Object> cd, ConfigDesc configDesc) {
		super(beanDesc, cd, configDesc);
	}

	@Override
	public <T> void init() {
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T execute(T t, Lucy lucy) {
		AttributeContainer container = getAttributeContainer();
		if (container == null) {
			throw new IllegalStateException(
					"request/session/application must not be null.");
		}
		this.lock.lock();
		try {
			final BeanDesc<T> beanDesc = (BeanDesc<T>) getBeanDesc();
			t = findComponent(lucy, container, beanDesc);
			if (t == null) {
				Class<? extends T> concreteClass = beanDesc.getConcreteClass();
				t = ClassUtil.newInstance(concreteClass);
				beanDesc.setComponent(t);
				if (beanDesc.hasName()) {
					container.setAttribute(beanDesc.getComponentName(), t);
				} else {
					container.setAttribute(concreteClass.getName(), t);
				}
			}
		} finally {
			this.lock.unlock();
		}
		return t;
	}

	@SuppressWarnings("unchecked")
	protected <T> T findComponent(Lucy lucy, AttributeContainer container,
			BeanDesc<T> beanDesc) {
		T ret = null;
		if (beanDesc.hasName()) {
			// TODO it works without (T) cast at Eclipse, but not at maven2, so
			// simply cast it.
			ret = (T) container.getAttribute(beanDesc.getComponentName());
		}
		if (ret == null) {
			// TODO it works without (T) cast at Eclipse, but not at maven2, so
			// simply cast it.
			ret = (T) container.getAttribute(beanDesc.getConcreteClass()
					.getName());
		}
		return ret;
	}

	protected abstract AttributeContainer getAttributeContainer();

	@Override
	public Lifecycle getLifecycle() {
		return Lifecycle.COMPONENT_CREATING;
	}

}
