package org.t2framework.annotation.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <pre>
 * &#064;ActionPath is an annotation to notify that the annotated method is invoked by T2 
 * if the part of url is same as the annotation value.
 * At page class(it's just POJO), only you need is add ActionPath to the method 
 * which you would like to call from user action(usually it goes with @GET).
 * Here is how to use:
 * &#064;GET
 * &#064;ActionPath
 * public Navigation list() {
 *     //do something
 * }
 *  
 * Then, you just request with url like http://www.example.com/context-root/page-name/list
 * </pre>
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ActionPath {

	String value() default "";
}
