package org.t2framework.annotation.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <pre>
 * &#064;ActionParam is an annotation for action method which is invoked by T2 
 * if submitted the name attribute is same as method name.
 * At page class(it's just POJO), only you need is add ActionParam to the method 
 * which you would like to call from user action(usually it goes with @POST).
 * Here is how to use:
 * &#064;POST
 * &#064;ActionParam
 * public Navigation add(WebContext context) {
 *     //do something
 * }
 *  
 * Then, you just use submit button named &quot;add&quot;:
 * &lt;input type=&quot;submit&quot; name=&quot;add&quot; value=&quot;go&quot;/&gt;
 * </pre>
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ActionParam {

	String value() default "";

}
