package org.t2framework.adapter;

import java.util.Arrays;
import java.util.List;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

import org.t2framework.configuration.T2LucyConfiguration;
import org.t2framework.handler.ExceptionHandler;
import org.t2framework.handler.GlobalExceptionHandler;
import org.t2framework.handler.impl.GlobalExceptionHandlerImpl;

import lucy.Lucy;
import lucy.LucyBootstrap;

import commons.meta.BeanDesc;

/**
 * Concrete class of ContainerAdapter using Lucy.
 * 
 * @author shot
 * 
 */
public class LucyContainerAdapter implements ContainerAdapter<Lucy> {

	protected Lucy lucy;

	protected FilterConfig config;

	protected ServletContext servletContext;

	@Override
	public void destroy() {
		LucyBootstrap.destroy();
	}

	@Override
	public <T> T getComponent(Class<? super T> componentClass) {
		// TODO it works without (T) cast at Eclipse, but not at maven2, so
		// simply cast it.
		return (T) lucy.get(componentClass);
	}

	@Override
	public void init() {
		this.lucy = LucyBootstrap.init(new T2LucyConfiguration());
	}

	@Override
	public void init(String configPath) {
		this.lucy = LucyBootstrap.init(new T2LucyConfiguration(), configPath);
	}

	@Override
	public <T> void register(T component) {
		lucy.register(component);
	}

	@Override
	public <T> void register(Class<? extends T> clazz) {
		lucy.register(clazz);
	}

	@Override
	public <T> BeanDesc<T> getBeanDesc(Class<? super T> componentClass) {
		return lucy.getBeanDesc(componentClass);
	}

	@Override
	public Lucy getContainer() {
		return lucy;
	}

	@Override
	public void setFilterConfig(FilterConfig config) {
		this.config = config;
	}

	@Override
	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<ExceptionHandler<Throwable, Exception>> createExceptionHandlers() {
		ExceptionHandler<Throwable, Exception>[] handlers = lucy
				.getAll(ExceptionHandler.class);
		return Arrays.asList(handlers);
	}

	@Override
	public GlobalExceptionHandler createGlobalExceptionHandler() {
		return new GlobalExceptionHandlerImpl();
	}

	@Override
	public <T> boolean hasComponent(Class<T> componentClass) {
		return this.lucy.get(componentClass) != null;
	}

	@Override
	public <T> T injectDependency(T t) {
		return lucy.injectDependency(t);
	}

	@Override
	public <T> List<T> getComponents(Class<? super T> componentClass) {
		// TODO it works without (T) cast at Eclipse, but not at maven2, so
		// simply cast it.
		return (List<T>) Arrays.asList(lucy.getAll(componentClass));
	}

}
