package org.t2framework.adapter;

import java.util.List;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

import org.t2framework.handler.ExceptionHandlerFactory;

import commons.meta.BeanDesc;

/**
 * Container adapter for using DI container.
 * 
 * @author shot
 * 
 * @param <C>
 */
public interface ContainerAdapter<C> extends ContainerResource<C>,
		ExceptionHandlerFactory {

	void init();

	void init(String configPath);

	<T> boolean hasComponent(Class<T> componentClass);

	<T> T getComponent(Class<? super T> componentClass);

	<T> List<T> getComponents(Class<? super T> componentClass);

	<T> BeanDesc<T> getBeanDesc(Class<? super T> componentClass);

	<T> void register(Class<? extends T> clazz);

	<T> void register(T component);

	void destroy();

	void setServletContext(ServletContext servletContext);

	void setFilterConfig(FilterConfig config);

	<T> T injectDependency(T t);
}
