package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import org.t2framework.action.ActionContext;
import org.t2framework.annotation.core.SessionAttr;
import org.t2framework.contexts.Session;
import org.t2framework.exception.InvalidSessionAttributeTypeRuntimeException;
import org.t2framework.exception.SessionAttributeNotFoundRuntimeException;

import commons.meta.MethodDesc;

/**
 * SessionAttributeResolver is a resolver class to inject session attribute.
 * 
 * @author taichi
 */
public class SessionAttributeResolver extends AbstractParameterResolver {

	public SessionAttributeResolver() {
		setTargetAnnotationClass(SessionAttr.class);
	}

	/**
	 * Return HttpSession.getAttribute if SessionAttr(parameter
	 * annotation).value matches.The return value would be parameter type.
	 * 
	 * @return Object
	 */
	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		final Session session = actionContext.getSession();
		SessionAttr annotation = findTargetAnnotation(paramAnnotations,
				this.targetAnnotationClass);
		final String key = annotation.value();
		Object value = session.getAttribute(key);
		if (value == null) {
			throw new SessionAttributeNotFoundRuntimeException(key);
		}
		Class<?> clazz = value.getClass();
		if (paramClass.isAssignableFrom(clazz) == false) {
			throw new InvalidSessionAttributeTypeRuntimeException(paramClass,
					clazz);
		}
		return value;
	}

}
