package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import javax.servlet.ServletContext;

import org.t2framework.action.ActionContext;

import commons.meta.MethodDesc;

/**
 * ServletContextParameterResolver is a concrete class of ParameterResolver, and
 * is responsible for returning ServletContext.
 * 
 * @author shot
 */
public class ServletContextParameterResolver extends AbstractParameterResolver {

	public ServletContextParameterResolver() {
		setTargetClass(ServletContext.class);
	}

	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		return actionContext.getApplication().getNativeResource();
	}
}
