package org.t2framework.action.impl;

import java.util.Map;

import org.t2framework.action.PageDescFinder;
import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.WebContext;
import org.t2framework.util.PathUtil;

public class PageDescFinderImpl implements PageDescFinder {

	/**
	 * Return true if WebContext is not null and Map has some values.
	 */
	@Override
	public boolean isApplied(WebContext context,
			Map<String, PageDesc> pageDescMap) {
		return context != null && pageDescMap != null && !pageDescMap.isEmpty();
	}

	/**
	 * Return PageDesc if requested path, which is calculated by PathUtil, is
	 * matched.
	 * 
	 * @see org.t2framework.util.PathUtil
	 */
	@Override
	public PageDesc find(final WebContext context,
			final Map<String, PageDesc> pageDescMap) {
		final String path = PathUtil.getPagePath(context.getRequest());
		for (PageDesc pd : pageDescMap.values()) {
			if (pd.match(path)) {
				return pd;
			}
		}
		return null;
	}

}
