package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import javax.servlet.http.HttpSession;

import org.t2framework.action.ActionContext;

import commons.meta.MethodDesc;

/**
 * HttpSessionParameterResolver is a concrete class of ParameterResolver, and is
 * responsible for returning HttpSession.If there is no HttpSession, then create
 * one and return.
 * 
 * @author shot
 */
public class HttpSessionParameterResolver extends AbstractParameterResolver {

	public HttpSessionParameterResolver() {
		setTargetClass(HttpSession.class);
	}

	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		return actionContext.getRequest().getNativeResource().getSession(true);
	}
}
