package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import javax.servlet.http.HttpServletResponse;

import org.t2framework.action.ActionContext;

import commons.meta.MethodDesc;

/**
 * HttpServletResponseParameterResolver is a concrete class of
 * ParameterResolver, and is responsible for returning HttpServletRespnse if
 * applicable.
 * 
 * @author shot
 */
public class HttpServletResponseParameterResolver extends
		AbstractParameterResolver {

	public HttpServletResponseParameterResolver() {
		setTargetClass(HttpServletResponse.class);
	}

	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		return actionContext.getResponse().getNativeResource();
	}
}
