package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import javax.servlet.http.HttpServletRequest;

import org.t2framework.action.ActionContext;

import commons.meta.MethodDesc;

/**
 * HttpServletRequestParameterResolver is a concrete class of ParameterResolver,
 * and is responsible for returning HttpServletRequest if applicable.
 * 
 * @author shot
 */
public class HttpServletRequestParameterResolver extends
		AbstractParameterResolver {

	public HttpServletRequestParameterResolver() {
		setTargetClass(HttpServletRequest.class);
	}

	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		return actionContext.getRequest().getNativeResource();
	}
}
