package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import org.t2framework.action.ActionContext;
import org.t2framework.util.UrlTemplate;

import commons.meta.MethodDesc;
import commons.util.Assertion;

/**
 * DefaultAnnotationResolver handles &#064;Default.
 * 
 * @author shot
 */
public class DefaultAnnotationResolver extends
		AbstractTemplateValueActionAnnotationResolver {

	@Override
	public boolean isMatch(final ActionContext actionContext,
			final Annotation annotation) {
		return true;
	}

	@Override
	public void resolve(ActionContext actionContext, Annotation annotation) {
		Assertion.notNull(actionContext);
		final MethodDesc defaultMethodDesc = actionContext
				.getDefaultMethodDesc();
		final UrlTemplate template = factory.getUrlTemplate(actionContext
				.getPageTemplatePath());
		actionContext.addUrlTemplate(defaultMethodDesc, template);
	}

	@Override
	protected String getTemplateValue(MethodDesc methodDesc,
			Annotation annotation) {
		return null;
	}
}
