package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import javax.servlet.http.Cookie;

import org.t2framework.action.ActionContext;
import org.t2framework.exception.InvalidRequestParameterTypeRuntimeException;

import commons.meta.MethodDesc;

/**
 * CookieParameterResolver is a concrete class of ParameterResolver, and is
 * responsible for returning a Cookie.
 * 
 * @author shot
 */
public class CookieParameterResolver extends AbstractParameterResolver {

	public CookieParameterResolver() {
		setTargetClass(Cookie.class);
	}

	/**
	 * <pre>
	 * Get {@code Cookie} or {@code Cookie}[] if available.
	 * 
	 * [Features of return value]
	 *  The return value must be {@code Cookie} or {@code Cookie}[]. 
	 *  
	 * [In case of fail]
	 *  If there is no {@code Cookie}, simplly return null.
	 *  Or if paramClass is not {@code Cookie}.class or {@code Cookie}[].class, 
	 *  throw InvalidRequestParameterTypeRuntimeException.
	 *  
	 * [Etc]
	 *  Nothing.
	 * </pre>
	 * 
	 * @param actionContext
	 *            : ActionContext, context instance.
	 * @param md
	 *            : MethodDesc, the target method meta-class instance.
	 * @param paramIndex
	 *            : Index of method parameter.
	 * @param paramAnnotations
	 *            : Parameter annotations for the target parameter.
	 * @param paramClass
	 *            : Parameter class.
	 * @return object : Cookie or Cookie[].
	 * @throws InvalidRequestParameterTypeRuntimeException
	 *             in case of paramClass is not {@code Cookie}.class or {@code
	 *             Cookie}[].class.
	 * @see javax.servlet.http.Cookie
	 */
	@Override
	public Object resolve(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
		Cookie[] cookies = actionContext.getRequest().getNativeResource()
				.getCookies();
		if (cookies == null || cookies.length == 0) {
			return null;
		} else if (paramClass == Cookie.class) {
			return cookies[0];
		} else if (paramClass.isArray()
				&& paramClass.getComponentType() == Cookie.class) {
			return cookies;
		}
		throw new InvalidRequestParameterTypeRuntimeException();
	}

}
