package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import org.t2framework.action.ActionContext;
import org.t2framework.annotation.core.ActionPath;
import org.t2framework.contexts.Request;
import org.t2framework.util.PathUtil;
import org.t2framework.util.UrlTemplate;

import commons.meta.MethodDesc;
import commons.util.StringUtil;

/**
 * ActionPathAnnotationResolver is a concrete class of ActionAnnotationResolver.
 * It handles &#064;ActionPath.
 * 
 * @author shot
 */
public class ActionPathAnnotationResolver extends
		AbstractTemplateValueActionAnnotationResolver {

	@Override
	public boolean isMatch(final ActionContext actionContext,
			final Annotation annotation) {
		final UrlTemplate template = getUrlTemplate(actionContext
				.getTargetMethodDesc(), annotation);
		final Request request = actionContext.getRequest();
		final String pagePath = actionContext.getPageTemplatePath();
		String testPath = PathUtil.getActionMethodDescPath(request, pagePath);
		if (template.match(testPath)) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public String getTemplateValue(MethodDesc methodDesc, Annotation annotation) {
		final ActionPath actionPath = (ActionPath) annotation;
		final String value = actionPath.value();
		return !StringUtil.isEmpty(value) ? value : methodDesc.getMethodName();
	}
}
