package org.t2framework.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.regex.Pattern;

import org.t2framework.action.ActionContext;
import org.t2framework.annotation.core.ActionParam;
import org.t2framework.util.UrlTemplate;

import commons.meta.MethodDesc;
import commons.util.StringUtil;

/**
 * ActionParamAnnotationResolver is a concrete class of
 * ActionAnnotationResolver. This class handles &#064;ActionParam.
 * 
 * @author shot
 * @see org.t2framework.action.ActionAnnotationResolver
 */
public class ActionParamAnnotationResolver extends
		AbstractTemplateValueActionAnnotationResolver {

	@Override
	public boolean isMatch(final ActionContext actionContext,
			final Annotation annotation) {
		UrlTemplate template = getUrlTemplate(actionContext
				.getTargetMethodDesc(), annotation);
		List<Pattern> patterns = template.getUrlPattern();
		for (String paramKey : actionContext.getRequest().getParameterNames()) {
			for (Pattern pattern : patterns) {
				if (pattern.matcher(paramKey).matches()) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	protected String getTemplateValue(MethodDesc methodDesc,
			Annotation annotation) {
		final ActionParam actionParam = (ActionParam) annotation;
		final String value = actionParam.value();
		return !StringUtil.isEmpty(value) ? value : methodDesc.getMethodName();
	}

}
