package org.t2framework.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.t2framework.action.ActionContext;
import org.t2framework.annotation.core.Default;
import org.t2framework.contexts.ActionMethodDesc;
import org.t2framework.contexts.Application;
import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.Response;
import org.t2framework.contexts.Session;
import org.t2framework.contexts.WebContext;
import org.t2framework.exception.NoTargetPageDescFoundRuntimeException;
import org.t2framework.util.UrlTemplate;

import commons.meta.ConfigDesc;
import commons.meta.MethodDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * Concrete class of ActionContext.
 * 
 * @author shot
 * @see org.t2framework.action.ActionContext
 */
public class ActionContextImpl implements ActionContext {

	protected PageDesc targetPageDesc;

	protected MethodDesc targetMethodDesc;

	protected final WebContext context;

	protected int matchCount = 0;

	protected Object body;

	protected flex.messaging.io.amf.ActionContext amfActionContext;

	protected Map<MethodDesc, List<UrlTemplate>> templatesMap = CollectionsUtil
			.newHashMap();

	public ActionContextImpl(final WebContext context) {
		this.context = context;
	}

	public ActionContextImpl(final WebContext context,
			final PageDesc targetPageDesc) {
		this.context = context;
		setTargetPageDesc(targetPageDesc);
	}

	@Override
	public void setTargetPageDesc(PageDesc targetPageDesc) {
		this.targetPageDesc = targetPageDesc;
	}

	protected ActionMethodDesc getActionMethodDesc() {
		return getTargetPageDesc().getActionMethodDesc();
	}

	@Override
	public PageDesc getTargetPageDesc() {
		if (this.targetPageDesc == null) {
			throw new NoTargetPageDescFoundRuntimeException();
		}
		return targetPageDesc;
	}

	@Override
	public Set<String> getMethodNameList() {
		return getActionMethodDesc().getMethodNameList();
	}

	@Override
	public MethodDesc getMethodDesc(String methodName) {
		return getActionMethodDesc().getMethodDesc(methodName);
	}

	@Override
	public MethodDesc getTargetMethodDesc() {
		return targetMethodDesc;
	}

	@Override
	public synchronized void setTargetMethodDesc(MethodDesc methodDesc) {
		this.targetMethodDesc = methodDesc;
	}

	@Override
	public String getPageTemplatePath() {
		return getTargetPageDesc().getPageTemplatePath();
	}

	@Override
	public Request getRequest() {
		return context.getRequest();
	}

	public void incrementMatchCount() {
		matchCount++;
	}

	public void clearMatchCount() {
		matchCount = 0;
	}

	public int getMatchCount() {
		return matchCount;
	}

	@Override
	public void addUrlTemplate(MethodDesc methodDesc, UrlTemplate template) {
		Assertion.notNull(methodDesc);
		Assertion.notNull(template);
		List<UrlTemplate> list = templatesMap.get(methodDesc);
		if (list == null) {
			list = CollectionsUtil.newArrayList();
		}
		list.add(template);
		templatesMap.put(methodDesc, list);
	}

	@Override
	public UrlTemplate[] getUrlTemplates() {
		return getUrlTemplates(targetMethodDesc);
	}

	@Override
	public UrlTemplate[] getUrlTemplates(MethodDesc methodDesc) {
		List<UrlTemplate> templates = templatesMap.get(methodDesc);
		if (templates == null) {
			return null;
		}
		return templates.toArray(new UrlTemplate[0]);
	}

	@Override
	public MethodDesc getDefaultMethodDesc() {
		return getTargetPageDesc().getDefaultMethodDesc();
	}

	@Override
	public boolean hasDefaultMethodDesc() {
		return getTargetPageDesc().hasDefaultMethodDesc();
	}

	@Override
	public Response getResponse() {
		return context.getResponse();
	}

	@Override
	public Session getSession() {
		return context.getSession();
	}

	@Override
	public Application getApplication() {
		return context.getApplication();
	}

	@Override
	public Annotation getDefaultAnnotation() {
		final ConfigDesc configDesc = getDefaultMethodDesc().getConfigDesc(
				Default.class);
		if (configDesc == null)
			return null;
		return configDesc.getAnnotation();
	}

	@Override
	public flex.messaging.io.amf.ActionContext getAmfActionContext() {
		return amfActionContext;
	}

	@Override
	public void setAmfActionContext(
			flex.messaging.io.amf.ActionContext amfActionContext) {
		this.amfActionContext = Assertion.notNull(amfActionContext);
	}

}
