package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import org.t2framework.action.ActionAnnotationResolver;
import org.t2framework.action.ActionContext;
import org.t2framework.util.UrlTemplate;
import org.t2framework.util.UrlTemplateFactory;
import org.t2framework.util.impl.UrlTemplateFactoryImpl;

import commons.meta.MethodDesc;
import commons.util.Assertion;

/**
 * 
 * @author shot
 * 
 */
public abstract class AbstractTemplateValueActionAnnotationResolver implements
		ActionAnnotationResolver {

	protected UrlTemplateFactory factory = new UrlTemplateFactoryImpl();

	protected UrlTemplate createTemplate(final String templatePath) {
		return factory.getUrlTemplate(Assertion.notNull(templatePath));
	}

	public void setUrlTemplateFactory(UrlTemplateFactory factory) {
		this.factory = factory;
	}

	protected UrlTemplate getUrlTemplate(MethodDesc methodDesc,
			Annotation annotation) {
		Assertion.notNull(methodDesc);
		Assertion.notNull(annotation);
		final String templatePath = getTemplateValue(methodDesc, annotation);
		return createTemplate(templatePath);
	}

	protected UrlTemplate getUrlTemplate(String prefix, MethodDesc methodDesc,
			Annotation annotation) {
		Assertion.notNull(prefix);
		Assertion.notNull(methodDesc);
		Assertion.notNull(annotation);
		String templatePath = getTemplateValue(methodDesc, annotation);
		if (!prefix.endsWith("/") && !templatePath.startsWith("/")) {
			templatePath = prefix + "/" + templatePath;
		} else {
			templatePath = prefix + templatePath;
		}
		return createTemplate(templatePath);
	}

	@Override
	public void resolve(ActionContext actionContext, Annotation annotation) {
		final MethodDesc methodDesc = actionContext.getTargetMethodDesc();
		final UrlTemplate template = getUrlTemplate(actionContext
				.getPageTemplatePath(), methodDesc, annotation);
		actionContext.addUrlTemplate(methodDesc, template);
	}

	protected abstract String getTemplateValue(final MethodDesc methodDesc,
			final Annotation annotation);

	@Override
	public void preResolve(ActionContext actionContext, Annotation annotation) {
	}

	@Override
	public void postResolve(ActionContext actionContext, Annotation annotation) {
	}

}
