package org.t2framework.action.impl;

import java.lang.annotation.Annotation;

import org.t2framework.action.ActionContext;
import org.t2framework.action.ParameterResolver;

import commons.meta.MethodDesc;
import commons.util.Assertion;

/**
 * 
 * @author shot
 * 
 */
public abstract class AbstractParameterResolver implements ParameterResolver {

	protected Class<?> targetClass;

	protected Class<?> targetAnnotationClass;

	@Override
	public boolean isTargetParameter(ActionContext actionContext,
			MethodDesc md, int paramIndex, Annotation[] paramAnnotations,
			Class<?> paramClass) {
		Assertion.notNulls(paramAnnotations, paramClass);
		if (targetAnnotationClass != null) {
			Annotation annotation = findTargetAnnotation(paramAnnotations,
					targetAnnotationClass);
			if (annotation != null) {
				return true;
			}
		}
		if (targetClass != null && targetClass == paramClass) {
			return true;
		}
		return false;
	}

	@SuppressWarnings("unchecked")
	protected <A> A findTargetAnnotation(Annotation[] annotations,
			Class<?> targetAnnotationClass) {
		Assertion.notNulls(annotations, targetAnnotationClass);
		for (Annotation annotation : annotations) {
			if (annotation.annotationType() == targetAnnotationClass) {
				return (A) annotation;
			}
		}
		return null;
	}

	public void setTargetClass(Class<?> targetClass) {
		this.targetClass = targetClass;
	}

	public void setTargetAnnotationClass(Class<?> targetAnnotationClass) {
		this.targetAnnotationClass = targetAnnotationClass;
	}

	public Class<?> getTargetClass() {
		return targetClass;
	}

	public Class<?> getTargetAnnotationClass() {
		return targetAnnotationClass;
	}

}
