package org.t2framework.action;

import java.lang.annotation.Annotation;

import commons.annotation.Published;
import commons.meta.MethodDesc;

/**
 * Resolve ActionMethod's parameter.
 * 
 * @author AKatayama
 * @author shot
 */
@Published
public interface ParameterResolver {

	/**
	 * If this ParameterResolver.resolve() should be invoked or not.
	 * 
	 * @param actionContext
	 * @param md
	 * @param paramIndex
	 * @param paramAnnotations
	 * @param paramClass
	 * @return
	 */
	boolean isTargetParameter(ActionContext actionContext, MethodDesc md,
			int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass);

	/**
	 * Resolve parameter.
	 * 
	 * @param actionContext
	 * @param md
	 * @param paramIndex
	 * @param paramAnnotations
	 * @param paramClass
	 * @return
	 */
	Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex,
			Annotation[] paramAnnotations, Class<?> paramClass);
}
