package org.t2framework.action;

import java.util.Map;

import org.t2framework.action.impl.PageDescFinderImpl;
import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.WebContext;

import commons.util.Assertion;

public class PageDescFinderFactory {

	protected static PageDescFinder[] finders = { new PageDescFinderImpl() };

	public static PageDescFinder getPageDescFinder(final WebContext context,
			final Map<String, PageDesc> pageDescMap) {
		Assertion.notNull(context);
		Assertion.notNull(pageDescMap);
		for (PageDescFinder finder : finders) {
			if (finder.isApplied(context, pageDescMap)) {
				return finder;
			}
		}
		throw new IllegalStateException();
	}
}
