package org.t2framework.action;

import java.util.Map;

import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.WebContext;

/**
 * PageDescFinder is a finder interface for PageDesc. The concrete class of this
 * interface should be able to check and provide an appropriate PageDesc to its
 * user.
 * 
 * @author shot
 */
public interface PageDescFinder {

	/**
	 * Return if the instance of PageDescFinder is applicable.
	 * 
	 * @param context
	 * @param pageDescMap
	 * @return if the instance of PageDescFinder is applicable.
	 */
	boolean isApplied(final WebContext context,
			final Map<String, PageDesc> pageDescMap);

	/**
	 * Return applicable PageDesc for this instance.
	 * 
	 * @param context
	 * @param pageDescMap
	 * @return PageDesc
	 */
	PageDesc find(final WebContext context,
			final Map<String, PageDesc> pageDescMap);
}
