package org.t2framework.action;

import org.t2framework.spi.Navigation;

import commons.annotation.Published;

/**
 * ActionInvoker is an interface that has responsible for invoking action
 * method.
 * 
 * @author shot
 */
@Published
public interface ActionInvoker {

	/**
	 * Return if ActionInvoker should be invoked or not.
	 * 
	 * @return boolean
	 */
	boolean match();

	/**
	 * Invoke appropriate action method.
	 * 
	 * @return Navigation
	 */
	Navigation invoke();

	/**
	 * Set ActionContextBuilder that is responsible for building ActionContext
	 * instance.
	 * 
	 * @param creator
	 */
	void setActionContextBuilder(ActionContextBuilder creator);
}
