package org.t2framework.action;

import java.lang.annotation.Annotation;

import commons.annotation.Published;

/**
 * ActionContextBuilder is an interface which has responsible for building and
 * configuring ActionContext.
 * 
 * @author shot
 */
@Published
public interface ActionContextBuilder {

	/**
	 * Build and set up ActionContext.
	 * 
	 * @param actionContext
	 */
	void build(final ActionContext actionContext);

	/**
	 * Add ActionAnnotationResolver for an annotation class.
	 * 
	 * @param annotationClass
	 * @param resolver
	 */
	void addActionAnnotationResolver(
			final Class<? extends Annotation> annotationClass,
			final ActionAnnotationResolver resolver);

	/**
	 * Set default ActionAnnotationResolver, ActionContextBuilder can have only
	 * one default resolver.
	 * 
	 * @param defaultResolver
	 */
	void setDefaultActionAnnotationResolver(
			final ActionAnnotationResolver defaultResolver);
}
