package org.t2framework.action;

import java.lang.annotation.Annotation;
import java.util.Set;

import org.t2framework.contexts.Application;
import org.t2framework.contexts.PageDesc;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.Response;
import org.t2framework.contexts.Session;
import org.t2framework.util.UrlTemplate;

import commons.annotation.Published;
import commons.meta.MethodDesc;

/**
 * ActionContext is a context class that has all information for invoking an
 * action method.
 * 
 * @author shot
 */
@Published
public interface ActionContext {

	PageDesc getTargetPageDesc();

	Set<String> getMethodNameList();

	MethodDesc getMethodDesc(String methodName);

	void setTargetMethodDesc(MethodDesc methodDesc);

	MethodDesc getTargetMethodDesc();

	String getPageTemplatePath();

	Request getRequest();

	Response getResponse();

	Session getSession();

	Application getApplication();

	void incrementMatchCount();

	int getMatchCount();

	void clearMatchCount();

	void addUrlTemplate(MethodDesc methodDesc, UrlTemplate template);

	UrlTemplate[] getUrlTemplates();

	UrlTemplate[] getUrlTemplates(MethodDesc methodDesc);

	boolean hasDefaultMethodDesc();

	MethodDesc getDefaultMethodDesc();

	Annotation getDefaultAnnotation();

	void setAmfActionContext(
			flex.messaging.io.amf.ActionContext amfActionContext);

	flex.messaging.io.amf.ActionContext getAmfActionContext();

	void setTargetPageDesc(PageDesc targetPageDesc);

}
