package org.t2framework.action;

import java.lang.annotation.Annotation;

import commons.annotation.Published;

/**
 * ActionAnnotationResolver is an interface to resolve action method annotation.
 * 
 * @author shot
 */
public interface ActionAnnotationResolver {

	@Published
	boolean isMatch(final ActionContext actionContext,
			final Annotation annotation);

	void preResolve(final ActionContext actionContext,
			final Annotation annotation);

	@Published
	void resolve(final ActionContext actionContext, final Annotation annotation);

	void postResolve(final ActionContext actionContext,
			final Annotation annotation);
}
